package com.ejie.ab04b.model.nora;

/**
 * Calle.
 * 
 * @author GFI
 */
public class Calle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Clave compuesta
	private String codProvincia;
	private String codMunicipio;
	private String codLocalidad;
	private Long codCalle;
	private Long idCalle;
	private String descripcion;
	private String calleTxt;
	private String tipoVia;
	private String idTipoVia;

	/**
	 * Method 'Calle'.
	 */
	public Calle() {
		super();
	}

	/**
	 * Method 'Calle'.
	 * 
	 *  idCalle
	 *            Long
	 *
	 * @param idCalle the id calle
	 */
	public Calle(Long idCalle) {
		super();
		this.idCalle = idCalle;
	}

	/**
	 * Method 'Calle'.
	 * 
	 *  codProvincia
	 *            String
	 *  codMunicipio
	 *            String
	 *  codCalle
	 *            Long
	 *  idCalle
	 *            Long
	 *  descripcion
	 *            String
	 *  tipoVia
	 *            String
	 *  idTipoVia
	 *            String
	 *  calleTxt
	 *            String
	 *
	 * @param codProvincia the cod provincia
	 * @param codMunicipio the cod municipio
	 * @param codCalle the cod calle
	 * @param idCalle the id calle
	 * @param descripcion the descripcion
	 * @param tipoVia the tipo via
	 * @param idTipoVia the id tipo via
	 * @param calleTxt the calle txt
	 */
	public Calle(String codProvincia, String codMunicipio, Long codCalle, Long idCalle, String descripcion,
			String tipoVia, String idTipoVia, String calleTxt) {
		super();
		this.codProvincia = codProvincia;
		this.codMunicipio = codMunicipio;
		this.codCalle = codCalle;
		this.idCalle = idCalle;
		this.descripcion = descripcion;
		this.tipoVia = tipoVia;
		this.idTipoVia = idTipoVia;
		this.calleTxt = calleTxt;
	}

	/**
	 * Method 'getCodProvincia'.
	 * 
	 *  String
	 *
	 * @return the cod provincia
	 */
	public String getCodProvincia() {
		return this.codProvincia;
	}

	/**
	 * Method 'setCodProvincia'.
	 * 
	 *  codProvincia
	 *            String
	 *
	 * @param codProvincia the new cod provincia
	 */
	public void setCodProvincia(String codProvincia) {
		this.codProvincia = codProvincia;
	}

	/**
	 * Method 'getCodMunicipio'.
	 * 
	 *  String
	 *
	 * @return the cod municipio
	 */
	public String getCodMunicipio() {
		return this.codMunicipio;
	}

	/**
	 * Method 'setCodMunicipio'.
	 * 
	 *  codMunicipio
	 *            String
	 *
	 * @param codMunicipio the new cod municipio
	 */
	public void setCodMunicipio(String codMunicipio) {
		this.codMunicipio = codMunicipio;
	}

	/**
	 * Method 'getCodCalle'.
	 * 
	 *  Long
	 *
	 * @return the cod calle
	 */
	public Long getCodCalle() {
		return this.codCalle;
	}

	/**
	 * Method 'setCodCalle'.
	 * 
	 *  codCalle
	 *            Long
	 *
	 * @param codCalle the new cod calle
	 */
	public void setCodCalle(Long codCalle) {
		this.codCalle = codCalle;
	}

	/**
	 * Method 'getIdCalle'.
	 * 
	 *  Long
	 *
	 * @return the id calle
	 */
	public Long getIdCalle() {
		return this.idCalle;
	}

	/**
	 * Method 'setIdCalle'.
	 * 
	 *  idCalle
	 *            Long
	 *
	 * @param idCalle the new id calle
	 */
	public void setIdCalle(Long idCalle) {
		this.idCalle = idCalle;
	}

	/**
	 * Method 'getDescripcion'.
	 * 
	 *  String
	 *
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return this.descripcion;
	}

	/**
	 * Method 'setDescripcion'.
	 * 
	 *  descripcion
	 *            String
	 *
	 * @param descripcion the new descripcion
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 *  the tipoVia.
	 *
	 * @return the tipo via
	 */
	public String getTipoVia() {
		return this.tipoVia;
	}

	/**
	 *  tipoVia
	 *            the tipoVia to set.
	 *
	 * @param tipoVia the new tipo via
	 */
	public void setTipoVia(String tipoVia) {
		this.tipoVia = tipoVia;
	}

	/**
	 *  the idTipoVia.
	 *
	 * @return the id tipo via
	 */
	public String getIdTipoVia() {
		return this.idTipoVia;
	}

	/**
	 *  idTipoVia
	 *            the idTipoVia to set.
	 *
	 * @param idTipoVia the new id tipo via
	 */
	public void setIdTipoVia(String idTipoVia) {
		this.idTipoVia = idTipoVia;
	}

	/**
	 * Method 'getDescCompleta'.
	 * 
	 *  String
	 *
	 * @return the desc completa
	 */
	public String getDescCompleta() {
		StringBuilder str = new StringBuilder();
		if (this.descripcion != null && this.descripcion.length() > 0) {
			str.append(this.descripcion);
			if (this.tipoVia != null && this.tipoVia.length() > 0) {
				str.append(" (").append(this.tipoVia).append(")");
			}
			return str.toString();
		} else if (this.calleTxt != null && this.calleTxt.length() > 0) {
			return this.calleTxt;
		} else {
			return "";
		}

	}

	/**
	 * Method 'getDescCompletaSinTipoVia'.
	 * 
	 *  String
	 *
	 * @return the desc completa sin tipo via
	 */
	public String getDescCompletaSinTipoVia() {
		StringBuilder str = new StringBuilder();
		if (this.descripcion != null && this.descripcion.length() > 0) {
			str.append(this.descripcion);
			return str.toString();
		} else if (this.calleTxt != null && this.calleTxt.length() > 0) {
			return this.calleTxt;
		} else {
			return "";
		}

	}

	/**
	 *  the codLocalidad.
	 *
	 * @return the cod localidad
	 */
	public String getCodLocalidad() {
		return this.codLocalidad;
	}

	/**
	 *  codLocalidad
	 *            the codLocalidad to set.
	 *
	 * @param codLocalidad the new cod localidad
	 */
	public void setCodLocalidad(String codLocalidad) {
		this.codLocalidad = codLocalidad;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta
		result.append("[ codProvincia: ").append(this.codProvincia).append(" ]");
		result.append(", [ codMunicipio: ").append(this.codMunicipio).append(" ]");
		result.append(", [ codCalle: ").append(this.codCalle).append(" ]");
		result.append(", [ idCalle: ").append(this.idCalle).append(" ]");
		result.append(", [ descripcion: ").append(this.descripcion).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 *  the getCalleTxt.
	 *
	 * @return the calle txt
	 */
	public String getCalleTxt() {
		return calleTxt;
	}

	/**
	 *  calleTxt
	 *            String.
	 *
	 * @param calleTxt the new calle txt
	 */
	public void setCalleTxt(String calleTxt) {
		this.calleTxt = calleTxt;
	}
}